* Title: 	figure16.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of physical health


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure16, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use dta/brfss_clean, clear

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)

* Keep only 2011-2016
keep if year>=2011 & year<=2016


*******************************************************************************
* (2) Construct rates for regions
*******************************************************************************

* Drop those not reporting income, employment, or physical health
drop if income2 == 77 | income2 == 99 | income2 == . | Employed == . | HealthSevere == .

* Four groups: 	1) Employed, income >$50K
*				2) Employed, income $35K-50K
*				3) Employed, income <$35K
*				4) Not working
gen Status = .
replace Status = 1 if ((income2 >= 7 & income2 <= 8) & Employed == 1)
replace Status = 2 if ((income2 == 6) & Employed == 1)
replace Status = 3 if ((income2 >= 1 & income2 <= 5) & Employed == 1)
replace Status = 4 if Employed == 2

collapse (mean) HealthSevere [pw = _llcpwt], by(Status RegionI)

gen Severe_Rate = 100 * HealthSevere
drop HealthSevere

reshape wide Severe_Rate, i(RegionI) j(Status)

rename Severe_Rate1 Severe_Rate_Employed_HiIncome
rename Severe_Rate2 Severe_Rate_Employed_ModIncome
rename Severe_Rate3 Severe_Rate_Employed_LowIncome
rename Severe_Rate4 Severe_Rate_Jobless

* Save dataset
compress
save output/figures/dta/figure16.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

graph bar 	Severe_Rate*, over(Region) ///
			legend(label(1 "Employed >$50k") label(2 "Employed $35-50k") label(3 "Employed <$35k")  label(4 "Not Working")) ///
			graphregion(color(white)) bgcolor(white) ytitle("Percent reporting >10 days not good")

graph save output/figures/gph/figure16, replace
graph export output/figures/eps/figure16.eps, as(eps) replace
export excel using output/figures/xlsx/figure16.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
